// AUTOmatix 3D
// by Sebastian Reichelt
// Main Source File

#define SAVE_SCREEN

#ifdef ti89
short _ti89;
#endif
#ifdef ti92plus
short _ti92plus;
#endif

#include <tigcclib.h>
#include "Buffered Graphics.h"
#include "Car.h"

asm(".set __grayscale_support_not_included__,0");

TGraphBuffer *GraphBuffer;   // Graphics buffer to draw in

// This program substitutes OneSubst for 1 in certain floating point operations.
// Higher values provide more accurate display
#define OneSubst 20

// Distance from which you can see
#define VisiblePos (OneSubst / 10)

// Game speed factor (higher value = slower gameplay)
#define TimeFactor 300

#define RoadLineInterval (OneSubst * 2)

long RoadHeight, RoadWidth, HalfWidth;

long Time, CarPos, LastSpeedChangeTime, LastTurnTime, LastSpeedChangeCarPos;
long CarXPos, CarTurn, CarHeight, CarSlope, CarSpeed, LastTurnCarXPos;

#define BumpCount 14
long BumpXPoints   [BumpCount] = {0,             OneSubst * 10, OneSubst * 14,    OneSubst * 18, 0,             OneSubst * 30, OneSubst * 40, OneSubst * 40, OneSubst * 50,  OneSubst * 80, OneSubst * 80,  OneSubst * 120, OneSubst * 140, 0};
long BumpYPoints   [BumpCount] = {0,             0,             0x0FFFFFFF,       0,             0,             0,             0x0FFFFFFF,    0x0FFFFFFF,    0x0FFFFFFF,     0x0FFFFFFF,    0x0FFFFFFF,     0x0FFFFFFF,     0x0FFFFFFF,     0x0FFFFFFF};
long BumpBounds    [BumpCount] = {OneSubst * 10, OneSubst * 12, OneSubst * 16,    OneSubst * 18, OneSubst * 30, OneSubst * 35, OneSubst * 40, OneSubst * 50, OneSubst * 65,  OneSubst * 80, OneSubst * 100, OneSubst * 130, OneSubst * 140, 0x0FFFFFFF};
long BumpStretches [BumpCount] = {0,             OneSubst * 5,  -OneSubst * 5,    OneSubst * 5,  0,             OneSubst * 3,  -OneSubst * 3, 0,             -OneSubst * 1,  OneSubst * 1,  OneSubst * 2,   -OneSubst * 2,  OneSubst * 2,   0};

#define LeftSignCount 8
long LeftSigns  [LeftSignCount]  = {OneSubst * 1, OneSubst * 2, OneSubst * 3, OneSubst * 4, OneSubst * 5, OneSubst * 6, OneSubst * 7, OneSubst * 8};
#define RightSignCount 5
long RightSigns [RightSignCount] = {OneSubst * 9, OneSubst * 10, OneSubst * 11, OneSubst * 12, OneSubst * 13};

SCR_RECT *ScreenRect;
SCR_RECT ScrnRect;

#define FinishLine (OneSubst * 180)

// Functions
void RunLines(void);
void DrawUserCar(int X, int Y, int Turn);
void DrawObjects(long LastDistance, long Distance, int ScrY, int ScrX, int ScrW, int Factor);
void DrawSign(int X, int Y, int RightSign, int Factor);
void DrawFinish(int X1, int X2, int Y, int Factor);
void InitBumps(void);

#define GetDist(X, Y) (OneSubst * OneSubst * (Y) / (X) - OneSubst)

long GetRoadX(long Dist);
long GetRoadY(long Dist);

// Main Function
void _main(void)
{
	INT_HANDLER Intrs [AUTO_INT_COUNT];
	int Quit = 0, Finished = 0, F = 0;
	long LastTurn = 0, LastTime = 0, TimeChange = 0, Turn = 0, SpeedChange = 0, I = 0;
	unsigned char KeyInput;
	char S [30];
	
	ClrScr();
	
	for (F = FIRST_AUTO_INT; F <= LAST_AUTO_INT; F++)
	{
		Intrs [F - FIRST_AUTO_INT] = GetIntVec (AUTO_INT (F));
		SetIntVec (AUTO_INT (F), DUMMY_HANDLER);
	}
	
	ScrnRect.xy.x0 = 0;
	ScrnRect.xy.y0 = 0;
	ScrnRect.xy.x1 = LCDWidth - 1;
	ScrnRect.xy.y1 = LCDHeight - 1;
	ScreenRect = &ScrnRect;
	
	// Initialize for grayscale graphics
	GraphInit(2);
	GraphBuffer = CreateBuf (CurGrayPlanes);
	FlushBuf (GraphBuffer);

	InitBumps();
	
	RoadHeight = LCDHeight * 2 / 5;
	RoadWidth = LCDWidth * 5 / 3;
	
	CarTurn = 0;
	CarXPos = 0;
	CarPos = 0;
	CarSpeed = 200;  // divide by 10 to get actual speed
	LastSpeedChangeTime = 0;
	LastSpeedChangeCarPos = 0;
	LastTurnTime = 0;
	LastTurnCarXPos = 0;
	LastTime = -1;
	for (Time = 0; !Quit; Time++)
	{
		LastTurn = CarTurn;
		SpeedChange = -10;
		Turn = 0;
		KeyInput = _rowread (0xFFFE);  // top row
		if (KeyInput & 0x10)     // 2nd
		{
			if (CarSpeed < 2470)
				SpeedChange = 20;
			else
				SpeedChange = 0;
		}
		if (KeyInput & 0x40)     // diamond
			SpeedChange = -100;
		if ((KeyInput & 0x0A) != 0x0A)  // not left and right together
		{
			if (KeyInput & 0x02)   // left
				Turn = -1;
			if (KeyInput & 0x08)   // right
				Turn = 1;
		}
		KeyInput = _rowread (0xFFBF);  // ESC row
		if (KeyInput & 0x01)     // ESC
			Quit = 1;
		if (abs (GetRoadX (CarPos) - CarXPos) > RoadWidth / 2)
			if (CarSpeed > 600)
				SpeedChange = -150;
		TimeChange = Time - LastTime;
		if (Turn)
		{
			if (SpeedChange < 0)
				I = 3000;
			else
				I = 5000;
			CarTurn += Turn * TimeChange * OneSubst * CarSpeed / I;
		}
		if ((CarTurn != LastTurn) || (LastTurnTime < LastSpeedChangeTime))
		{
			LastTurnTime = LastTime;
			LastTurnCarXPos = CarXPos;
		}
		if (SpeedChange)
		{
			CarSpeed += SpeedChange * TimeChange;
			if (CarSpeed < 0)
				CarSpeed = 0;
			LastSpeedChangeTime = LastTime;
			LastSpeedChangeCarPos = CarPos;
		}
		CarPos = LastSpeedChangeCarPos + (Time - LastSpeedChangeTime) * CarSpeed / TimeFactor;
		CarXPos = LastTurnCarXPos + (Time - LastTurnTime) * CarSpeed * CarTurn / TimeFactor / OneSubst;
		RunLines();
		DrawUserCar (LCDWidth / 2, LCDHeight - 1, Turn);
		if (CarPos >= FinishLine)
		{
			if (abs (GetRoadX (CarPos) - CarXPos) <= RoadWidth / 2)
				Finished = 1;
			Quit = 1;
		}
		FlushBuf (GraphBuffer);
		LastTime = Time;
	}
	
	FreeBuf (GraphBuffer);
	GraphDone();
	ClrScr();
	F = FontSetSys (F_8x10);
	if (Finished)
	{
		DrawStr (ScrnRect.xy.x1 / 2 - 36, ScrnRect.xy.y1 / 2 - 20, "Finished!", A_NORMAL);
		FontSetSys (F_6x8);
		sprintf (S, "Time: %lu", LastTime);
		DrawStr (10, ScrnRect.xy.y1 / 2 + 5, S, A_NORMAL);
	}
	else
	{
		DrawStr (ScrnRect.xy.x1 / 2 - 36, ScrnRect.xy.y1 / 2 - 20, "Race Over", A_NORMAL);
	}
	FontSetSys (F);
	while (  (char) _rowread (0xFFBC) ) idle();
	while (!((char) _rowread (0xFFBC))) idle();
	while (  (char) _rowread (0xFFBC) ) idle();
	
	for (F = FIRST_AUTO_INT; F <= LAST_AUTO_INT; F++)
		SetIntVec (AUTO_INT (F), Intrs [F - FIRST_AUTO_INT]);
	
	GKeyFlush();
	ClrScr();
}

// Other Functions
void RunLines(void)
{
	int XPos, YPos, ScrX, ScrY, LastScrX = 0, LastScrY, CurScrX, TrapLoop, Horizon, ScrW, LastScrW = 0, CurScrW, I, Dist, LPS, LPE;
	long Distance, LastDistance, CurD, CurLastD, Factor, LastFactor = 0, CurFactor;
	TColor RoadAttr, SideAttr;
	
	CarHeight = 0;
	CarHeight = -GetRoadY (CarPos);
	CarSlope = GetRoadY (CarPos + OneSubst) - GetRoadY (CarPos);
	Horizon = ScreenRect->xy.y1 - RoadHeight + CarSlope;
	LastDistance = CarPos;
	LastScrY = Horizon;
	
	DrawFullHLinesBuf (GraphBuffer, 0, Horizon, clWhite);
	
	for (I = VisiblePos; I <= OneSubst; I++)
	{
		Dist = GetDist (I, 1);
		Distance = Dist + CarPos;
		if ((Distance / (RoadLineInterval / 2)) & 0x1)
		{
			RoadAttr = clGray;
			SideAttr = clLightSilver;
		}
		else
		{
			RoadAttr = clBlack;
			SideAttr = clSilver;
		}
		XPos = (GetRoadX (Distance) - CarXPos - Dist * CarTurn / OneSubst) * I / OneSubst;
		YPos = (GetRoadY (Distance) + CarHeight - RoadHeight - Dist * CarSlope / OneSubst) * I / OneSubst;
		ScrX = LCDWidth / 2 + XPos;
		ScrY = ScreenRect->xy.y1 - RoadHeight - YPos;
		ScrW = RoadWidth * I / OneSubst / 2;
		
		if (ScrY != LastScrY)
		{
			if ((!LastScrW && ScrY > Horizon) || XPos > RoadWidth || XPos < -RoadWidth)
				DrawFullHLinesBuf (GraphBuffer, LastScrY, ScrY, LastScrW ? SideAttr : clSilver);
			else
			{
				LPS = LastScrY + 1;
				if (LPS < ScreenRect->xy.y0)
					LPS = ScreenRect->xy.y0 - 1;
				if (LPS > ScreenRect->xy.y1)
					LPS = ScreenRect->xy.y1 + 1;
				LPE = ScrY;
				if (LPE < ScreenRect->xy.y0)
					LPE = ScreenRect->xy.y0 - 1;
				if (LPE > ScreenRect->xy.y1)
					LPE = ScreenRect->xy.y1 + 1;
				Factor = 120 * I / OneSubst;
				CurLastD = LastDistance;
				for (TrapLoop = LPS; TrapLoop <= LPE; TrapLoop++)
				{
					//       {last pos}  {distance of Xs }   { returns a loop value between 0 and 1  }
					CurScrX = LastScrX + (ScrX - LastScrX) * (TrapLoop - LastScrY) / (ScrY - LastScrY);
					CurScrW = LastScrW + (ScrW - LastScrW) * (TrapLoop - LastScrY) / (ScrY - LastScrY);
					if ((TrapLoop >= ScreenRect->xy.y0) && (TrapLoop <= ScreenRect->xy.y1))
					{
//					DrawHLineBuf (GraphBuffer, ScreenRect->xy.x0, CurScrX - CurScrW - 1, TrapLoop, SideAttr);
//					DrawHLineBuf (GraphBuffer, CurScrX - CurScrW + 1, ScreenRect->xy.x1, TrapLoop, SideAttr);
						DrawFullHLineBuf (GraphBuffer, TrapLoop, SideAttr);
						DrawHLineBuf (GraphBuffer, CurScrX - CurScrW, CurScrX + CurScrW, TrapLoop, RoadAttr);
						DrawHLineBuf (GraphBuffer, CurScrX - CurScrW * 46 / 47 + 1, CurScrX - CurScrW * 44 / 47,     TrapLoop, clWhite);
						DrawHLineBuf (GraphBuffer, CurScrX + CurScrW * 44 / 47,     CurScrX + CurScrW * 46 / 47 - 1, TrapLoop, clWhite);
						if (!(((Distance * 2 + RoadLineInterval / 4) / (RoadLineInterval / 2)) & 0x1))
						{
							DrawHLineBuf (GraphBuffer, CurScrX - CurScrW * 16 / 47 + 1, CurScrX - CurScrW * 14 / 47,     TrapLoop, clWhite);
							DrawHLineBuf (GraphBuffer, CurScrX + CurScrW * 14 / 47,     CurScrX + CurScrW * 16 / 47 - 1, TrapLoop, clWhite);
						}
					}
					// Fake Distance Calculation
//				CurD = LastDistance + (Distance - LastDistance) * (TrapLoop - LastScrY) / (ScrY - LastScrY);
					CurD = GetDist ((I - 1) * ScrY - I * LastScrY + TrapLoop, ScrY - LastScrY) + CarPos;
					// Fake Size Calculation
					CurFactor = LastFactor + (Factor - LastFactor) * (TrapLoop - LastScrY) / (ScrY - LastScrY);
					DrawObjects (CurLastD, CurD, TrapLoop, CurScrX, CurScrW, CurFactor);
					CurLastD = CurD;
				}
				LastFactor = Factor;
			}
		}
		
		LastScrX = ScrX;
		LastScrY = ScrY;
		LastScrW = ScrW;
		LastDistance = Distance;
	}
}

long GetRoadX(long Dist)
{
	if (Dist >= 0)
	{
		if (Dist < OneSubst * 8)
			return 0;
		else if (Dist < OneSubst * 10)
			return ((Dist - OneSubst * 8) * (Dist - OneSubst * 8) / OneSubst);
		else if (Dist < OneSubst * 14)
			return (-(Dist - OneSubst * 12) * (Dist - OneSubst * 12) / OneSubst + 8 * OneSubst);
		else
			return (-(Dist - OneSubst * 15) * 4);
	}
	else
		return 0;
}

long GetRoadY(long Dist)
{
	int I;
	// General Formula: a(x+b)^2+c = a * (PartDist + b * OneSubst) * (PartDist + b * OneSubst) / OneSubst + c * OneSubst
	//                  where x = Dist / OneSubst  (the actual distance regardless of what OneSubst is)
	for (I = 0; I < BumpCount; I++)
	{
		if (Dist < BumpBounds [I])
		{
			Dist -= BumpXPoints [I];
			return (Dist * Dist * BumpStretches [I] / OneSubst / OneSubst + BumpYPoints [I]) / OneSubst;
		}
	}
	return 0;
}

void DrawUserCar(int X, int Y, int Turn)
{
	register PLCDBuffer PlanePtr = &(GraphBuffer->Planes [0]);
	register unsigned long *WordPtr;
	register int I;
	
	for (I = 0; I < 30; I++)
	{
		WordPtr = (unsigned long*) &((*PlanePtr) [(I + Y - 29) * LCDByteWidth + ((X >> 3) & 0xFE)]);
		*WordPtr &= CarMask [1][I];
		*WordPtr |= CarSprite [0][1][I];
		WordPtr--;
		*WordPtr &= CarMask [0][I];
		*WordPtr |= CarSprite [0][0][I];
	}

	if (GraphBuffer->PlaneCount > 1)
	{
		PlanePtr = &(GraphBuffer->Planes [1]);
		
		for (I = 0; I < 30; I++)
		{
			WordPtr = (unsigned long*) &((*PlanePtr) [(I + Y - 29) * LCDByteWidth + ((X >> 3) & 0xFE)]);
			*WordPtr &= CarMask [1][I];
			*WordPtr |= CarSprite [1][1][I];
			WordPtr--;
			*WordPtr &= CarMask [0][I];
			*WordPtr |= CarSprite [1][0][I];
		}
	}
	
	if (Turn < 0)
		DrawVLineBuf (GraphBuffer, X - 25, Y - 5, Y - 3, clBlack);
	else if (Turn > 0)
		DrawVLineBuf (GraphBuffer, X + 24, Y - 5, Y - 3, clBlack);
}

int ObjectInView(long Dist);

long LD = 0, D = 0;

int ObjectInView(long Dist)
{
	return ((Dist < LD) && (Dist >= D));
}
 
void DrawObjects(long LastDistance, long Distance, int ScrY, int ScrX, int ScrW, int Factor)
{
	if (Distance < LastDistance)
	{
		int I;
		LD = LastDistance;
		D = Distance;
		for (I = 0; I < LeftSignCount; I++)
			if (ObjectInView (LeftSigns [I]))
				DrawSign (ScrX - ScrW * 5 / 4, ScrY, 0, Factor);
		for (I = 0; I < RightSignCount; I++)
			if (ObjectInView (RightSigns [I]))
				DrawSign (ScrX + ScrW * 5 / 4, ScrY, 1, Factor);
		if (ObjectInView (FinishLine))
			DrawFinish (ScrX - ScrW, ScrX + ScrW, ScrY, Factor);
	}
}

void DrawSign(int X, int Y, int RightSign, int Factor)
{
	// Make RighSign be -1 or 1 for multiplication
	// A formula for this is: RightSign *= 2, RightSign--
	if (!RightSign)
		RightSign = -1;
	
	// Draw the sign's rectangle
	DrawRectBuf (GraphBuffer, X - Factor / 10, Y - Factor / 8, X + Factor / 10, Y, clBlack);
	
	{
		// Draw the arrow consisting of three white rectangles
		register int CurY;
		DrawRectBuf (GraphBuffer, X + Factor / 25 * RightSign, (CurY = Y - Factor / 20), X + RightSign, Y - Factor / 40 - 1, clWhite);
		DrawRectBuf (GraphBuffer, X, (CurY = Y - Factor * 3 / 40), X - Factor / 25 * RightSign, CurY - 1, clWhite);
		DrawRectBuf (GraphBuffer, X + Factor / 25 * RightSign, Y - Factor / 10, X + RightSign, CurY - 1, clWhite);
	}
}

void DrawFinish(int X1, int X2, int Y, int Factor)
{
	// left post
	DrawRectBuf (GraphBuffer, X1 - Factor / 20, Y - Factor / 2,   X1,               Y,              clGray);
	// right post
	DrawRectBuf (GraphBuffer, X2,               Y - Factor / 2,   X2 + Factor / 20, Y,              clGray);
	// top bar
	DrawRectBuf (GraphBuffer, X1 - Factor / 20, Y - Factor * 3/5, X2 + Factor / 20, Y - Factor / 2, clGray);
}

void InitBumps(void)
{
	int I;
	BumpStretches [0] = 0;
	for (I = 1; I < BumpCount; I++)
	{
		if (BumpYPoints [I] == 0x0FFFFFFF)
			BumpYPoints [I] =
				BumpStretches [I-1] *
				(BumpBounds [I-1] - BumpXPoints [I-1]) *
				(BumpBounds [I-1] - BumpXPoints [I-1]) /
				OneSubst / OneSubst + BumpYPoints [I-1] -
				BumpStretches [I] *
				(BumpBounds [I-1] - BumpXPoints [I]) *
				(BumpBounds [I-1] - BumpXPoints [I]) /
				OneSubst / OneSubst;
		if (BumpStretches [I] == 0x0FFFFFFF)
			BumpStretches [I] =
				(BumpStretches [I-1] *
				(BumpBounds [I-1] - BumpXPoints [I-1]) *
				(BumpBounds [I-1] - BumpXPoints [I-1]) +
				(BumpYPoints [I-1] - BumpYPoints [I]) *
				OneSubst * OneSubst) /
				((BumpBounds [I-1] - BumpXPoints [I]) *
				(BumpBounds [I-1] - BumpXPoints [I]));
	}
}
